/*
 * Decompiled with CFR 0.152.
 */
package com.sf.csim.express.service;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);

    public String post(String url, StringEntity entity) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = this.postForm(url, entity);
        String body = "";
        body = this.invoke(httpClient, (HttpUriRequest)post);
        try {
            httpClient.close();
        }
        catch (IOException e) {
            logger.error("HttpClientService post error", (Throwable)e);
        }
        return body;
    }

    public String post(String url, String name, String value) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("content", value));
        HttpPost post = this.postForm(url, (StringEntity)new UrlEncodedFormEntity(parameters, Charset.forName("UTF-8")));
        String body = "";
        body = this.invoke(httpClient, (HttpUriRequest)post);
        try {
            httpClient.close();
        }
        catch (IOException e) {
            logger.error("HttpClientService post error", (Throwable)e);
        }
        return body;
    }

    public String postSFAPI(String url, String xml, String verifyCode) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("xml", xml));
        parameters.add(new BasicNameValuePair("verifyCode", verifyCode));
        HttpPost post = this.postForm(url, (StringEntity)new UrlEncodedFormEntity(parameters, Charset.forName("UTF-8")));
        String body = "";
        body = this.invoke(httpClient, (HttpUriRequest)post);
        try {
            httpClient.close();
        }
        catch (IOException e) {
            logger.error("HttpClientService post error", (Throwable)e);
        }
        return body;
    }

    public String get(String url) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet get = new HttpGet(url);
        String body = "";
        body = this.invoke(httpClient, (HttpUriRequest)get);
        try {
            httpClient.close();
        }
        catch (IOException e) {
            logger.error("HttpClientService get error", (Throwable)e);
        }
        return body;
    }

    public String delete(String url) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpDelete delete = new HttpDelete(url);
        String body = "";
        body = this.invoke(httpClient, (HttpUriRequest)delete);
        try {
            httpClient.close();
        }
        catch (IOException e) {
            logger.error("HttpClientService get error", (Throwable)e);
        }
        return body;
    }

    public String invoke(CloseableHttpClient httpclient, HttpUriRequest httpost) {
        HttpResponse response = HttpClientUtil.sendRequest(httpclient, httpost);
        String body = "";
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            body = HttpClientUtil.parseResponse(response);
        }
        return body;
    }

    private static String parseResponse(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        String body = "";
        try {
            if (entity != null) {
                body = EntityUtils.toString((HttpEntity)entity);
            }
        }
        catch (ParseException e) {
            logger.error("HttpClientService paseResponse error", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("HttpClientService paseResponse error", (Throwable)e);
        }
        return body;
    }

    private static HttpResponse sendRequest(CloseableHttpClient httpclient, HttpUriRequest httpost) {
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute(httpost);
        }
        catch (ClientProtocolException e) {
            logger.error("HttpClientService sendRequest error", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("HttpClientService sendRequest error", (Throwable)e);
        }
        return response;
    }

    public HttpPost postForm(String url, StringEntity entity) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)entity);
        return httpPost;
    }
}

